/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.FileId;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class Auxiliary
extends Enum<Auxiliary> {
    public static final /* enum */ Auxiliary BibTex = new Auxiliary(){

        @Override
        String extension() {
            return ".aux";
        }

        @Override
        boolean doesFitAuxiliary(File file) {
            return this.doesFitAuxiliary(file, PATTERN_NEED_BIBTEX_RUN);
        }

        @Override
        int numRunsAfter() {
            return 2;
        }

        @Override
        FileId getIdent(File file) throws IOException {
            return this.updateIdentInclude(file, new FileId(), PATTERN_BIBTEX);
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runBibtex(desc);
        }
    };
    public static final /* enum */ Auxiliary Idx = new Auxiliary(){

        @Override
        String extension() {
            return ".idx";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeSplitIndex(desc);
        }
    };
    public static final /* enum */ Auxiliary Glo = new Auxiliary(){

        @Override
        String extension() {
            return ".aux";
        }

        @Override
        boolean doesFitAuxiliary(File file) {
            return this.doesFitAuxiliary(file, PATTERN_NEED_MAKEGLOSSARIES_RUN);
        }

        @Override
        FileId getIdent(File file) throws IOException {
            return this.updateIdentGls(file, new FileId());
        }

        FileId updateIdentGls(File file, FileId fileId) throws IOException {
            Throwable throwable = null;
            Object var5_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    Matcher matcher = PATTERN_INPUT_GLOSSARY.matcher((CharSequence)line);
                    if (matcher.find()) {
                        fileId.update(line);
                        File glossFile = TexFileUtils.replaceSuffix(file, "." + matcher.group(Auxiliary.GRP_EXT_GLOSS));
                        this.updateIdent(glossFile, fileId);
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return fileId;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeGlossary(desc);
        }
    };
    public static final /* enum */ Auxiliary Pyt = new Auxiliary(){

        @Override
        String extension() {
            return ".pytxcode";
        }

        @Override
        boolean mayBeEntryInToc() {
            return false;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runPythontex(desc);
        }
    };
    private static final Pattern PATTERN_NEED_BIBTEX_RUN;
    private static final Pattern PATTERN_NEED_MAKEGLOSSARIES_RUN;
    private static final Pattern PATTERN_INPUT;
    private static final String GRP_INPUT = "fileName";
    private static final Pattern PATTERN_INPUT_GLOSSARY;
    private static final String GRP_EXT_GLOSS = "fileExt";
    static final Pattern PATTERN_BIBTEX;
    private static final /* synthetic */ Auxiliary[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Auxiliary[]{BibTex, Idx, Glo, Pyt};
        PATTERN_NEED_BIBTEX_RUN = Pattern.compile((String)"^\\\\(bibdata|bibstyle)");
        PATTERN_NEED_MAKEGLOSSARIES_RUN = Pattern.compile((String)"^\\\\@istfilename");
        PATTERN_INPUT = Pattern.compile((String)"^\\\\@input\\{(?<fileName>.*)\\}");
        PATTERN_INPUT_GLOSSARY = Pattern.compile((String)"\\\\@newglossary\\{.+\\}\\{.+\\}\\{.+\\}\\{(?<fileExt>.*)\\}");
        PATTERN_BIBTEX = Pattern.compile((String)"^\\\\(citation|bibstyle|bibdata)");
    }

    abstract String extension();

    boolean doesFitAuxiliary(File file) {
        return file.exists();
    }

    boolean mayBeEntryInToc() {
        return true;
    }

    int numRunsAfter() {
        return 1;
    }

    abstract boolean process(LatexMainDesc var1, LatexProcessor var2) throws BuildFailureException;

    FileId getIdent(File file) throws IOException {
        return this.updateIdent(file, new FileId());
    }

    FileId updateIdent(File file, FileId fileId) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            while (line != null) {
                fileId.update(line);
                line = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return fileId;
    }

    FileId updateIdentInclude(File file, FileId fileId, Pattern patternAux) throws IOException {
        File parent = file.getParentFile();
        Throwable throwable = null;
        Object var7_7 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            while (line != null) {
                if (patternAux.matcher((CharSequence)line).find()) {
                    fileId.update(line);
                } else {
                    Matcher matcher = PATTERN_INPUT.matcher((CharSequence)line);
                    if (matcher.find()) {
                        String inFile = matcher.group(GRP_INPUT);
                        assert (inFile.endsWith(this.extension()));
                        this.updateIdentInclude(new File(parent, inFile), fileId, patternAux);
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return fileId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doesFitAuxiliary(File file, Pattern pattern) {
        if (!file.exists()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    line = bufferedReader.readLine();
                }
                finally {
                    if (line != null) {
                    }
                    return false;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return true;
        }
    }

    public static Auxiliary[] values() {
        Auxiliary[] auxiliaryArray = ENUM$VALUES;
        int n = auxiliaryArray.length;
        Auxiliary[] auxiliaryArray2 = new Auxiliary[n];
        System.arraycopy(ENUM$VALUES, 0, auxiliaryArray2, 0, n);
        return auxiliaryArray2;
    }

    public static Auxiliary valueOf(String string) {
        return Enum.valueOf(Auxiliary.class, string);
    }
}

