/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.LogWrapper;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

class DocumentMetadata {
    private static final Pattern PATTERN_METADATA = Pattern.compile((String)"(\\s*,\\s*)?(?<key>[-a-z]+)(?:\\s*=\\s*(?<value>[^{}, ]+|\\{[^{}]*\\}))?");
    private static final String KEY_PDFVERSION = "pdfversion";
    private static final String KEY_UNCOMP = "uncompress";
    private static final String KEY_STD = "pdfstandard";
    private static final String KEY_XMP = "xmp";
    private static final String KEY_TAGGING = "tagging";
    boolean isExplicit;
    final LogWrapper log;
    final Optional<String> pdfversion;
    private boolean isCompressed;
    boolean withXMP;
    TaggingState tagging = TaggingState.off;
    private final Map<String, String> key2value;

    static DocumentMetadata docMetadata(LatexMainDesc desc, LogWrapper log) {
        if (!desc.groupMatches(LatexMainParameterNames.docMetadata)) {
            return new DocumentMetadata("xmp=false", false, log);
        }
        Optional<String> docMetadataValue = desc.groupMatch(LatexMainParameterNames.docMetadata);
        String docMetadataString = docMetadataValue.get();
        System.out.println("docMetadata: |" + docMetadataString + "|");
        return new DocumentMetadata(docMetadataString, true, log);
    }

    private static String unwrap(String str) {
        return (str = str.trim()).startsWith("{") && str.endsWith("}") ? str.substring(1, str.length() - 1) : str;
    }

    private DocumentMetadata(String docMetadataString, boolean isExplicit, LogWrapper log) {
        this.log = log;
        this.isCompressed = true;
        this.isExplicit = isExplicit;
        this.key2value = new TreeMap<String, String>();
        if (!this.isSpecMetadata()) {
            this.withXMP = false;
            this.pdfversion = Optional.empty();
            this.log.debug("No DocumentMetadata{...} found.");
            return;
        }
        this.withXMP = false;
        Matcher matcher = PATTERN_METADATA.matcher((CharSequence)docMetadataString);
        block8: while (matcher.find()) {
            String key = matcher.group("key");
            String valNew = matcher.group("value");
            System.out.println("key: |" + key + "| value: |" + valNew + "|");
            switch (key) {
                case "pdfstandard": {
                    String valOrg = this.key2value.get(KEY_STD);
                    valNew = DocumentMetadata.unwrap(valNew).toLowerCase();
                    if (valOrg == null) {
                        this.key2value.put(KEY_STD, valNew);
                        break;
                    }
                    this.key2value.put(KEY_STD, valOrg + "," + valNew);
                    break;
                }
                case "uncompress": {
                    if (valNew != null) {
                        this.log.warn(String.format("DMxx: found value '%s' which is not expected for key '%s'.", valNew, key));
                    }
                }
                default: {
                    String valOrg = this.key2value.put(key, valNew);
                    if (valOrg == null) continue block8;
                    this.log.warn(String.format("DMxx: Overwritten value '%s' by '%s' for key '%s'.", valOrg, valNew, key));
                }
            }
        }
        this.pdfversion = this.key2value.containsKey(KEY_PDFVERSION) ? Optional.of(this.key2value.get(KEY_PDFVERSION)) : Optional.empty();
        this.isCompressed = !this.key2value.containsKey(KEY_UNCOMP);
        this.withXMP = this.key2value.containsKey(KEY_XMP) ? Boolean.parseBoolean(this.key2value.get(KEY_XMP)) : true;
        this.tagging = this.key2value.containsKey(KEY_TAGGING) ? TaggingState.valueOf(this.key2value.get(KEY_TAGGING)) : TaggingState.off;
    }

    private boolean isSpecMetadata() {
        return this.isExplicit;
    }

    Optional<String> claimedStandard(StdType stdType) {
        String stdsStr = this.key2value.get(KEY_STD);
        if (stdsStr == null) {
            return Optional.empty();
        }
        Matcher matcher = Pattern.compile((String)String.format("^(.*,)?(?<std>%s-\\d+[a-z]*)", stdType.toString())).matcher((CharSequence)stdsStr);
        return matcher.find() ? Optional.of(matcher.group("std")) : Optional.empty();
    }

    static enum StdType {
        ua,
        a,
        x;

    }

    static enum TaggingState {
        on,
        off,
        draft;

    }
}

