/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.AbstractLatexProcessor;
import eu.simuline.m2latex.core.Auxiliary;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.FileId;
import eu.simuline.m2latex.core.FileMatch;
import eu.simuline.m2latex.core.Injection;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.LatexPreProcessor;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.MetaInfo;
import eu.simuline.m2latex.core.ParameterAdapter;
import eu.simuline.m2latex.core.Settings;
import eu.simuline.m2latex.core.Target;
import eu.simuline.m2latex.core.TargetsContext;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LatexProcessor
extends AbstractLatexProcessor {
    static final String PATTERN_OUFULL_HVBOX = "^(Ov|Und)erfull \\\\[hv]box \\(";
    static final String SUFFIX_TOC = ".toc";
    static final String SUFFIX_LOF = ".lof";
    static final String SUFFIX_LOT = ".lot";
    static final String SUFFIX_LOL = ".lol";
    static final String SUFFIX_AUX = ".aux";
    static final String SUFFIX_DVI = ".dvi";
    static final String SUFFIX_XDV = ".xdv";
    static final String SUFFIX_BLG = ".blg";
    static final String SUFFIX_BBL = ".bbl";
    static final String SUFFIX_IDX = ".idx";
    static final String SUFFIX_IND = ".ind";
    static final String SUFFIX_ILG = ".ilg";
    static final String SUFFIX_GLS = ".gls";
    static final String SUFFIX_GLG = ".glg";
    static final String SUFFIX_PLG = ".plg";
    private static final String SUFFIX_PYTXMCR = ".pytxmcr";
    private static final String SUFFIX_RTF = ".rtf";
    private static final String SUFFIX_ODT = ".odt";
    static final String SUFFIX_HTML = ".html";
    private static final String SUFFIX_TXT = ".txt";
    private static final String SUFFIX_CLG = ".clg";
    private static final String IMPL_IDENT_IDX = "idx";
    private static final String SEP_IDENT_IDX = "-";
    private final ParameterAdapter paramAdapt;
    private final LatexPreProcessor preProc;
    private final MetaInfo metaInfo;
    private Optional<String> latex2PdfCmdMagic = Optional.empty();
    static final int GRP_IDX_KEYPAGE = 3;
    static final int GRP_IDX_IDENT = 2;
    static final int GRP_IDX_IDXENTRY = 1;
    private static final FileId EMPTY_FILE_ID = new FileId().finalizFileId();
    private static final String FOLDER_INJ = "injections/";

    LatexProcessor(Settings settings, CommandExecutor executor, LogWrapper log, TexFileUtils fileUtils, ParameterAdapter paramAdapt) {
        super(settings, executor, log, fileUtils);
        this.paramAdapt = paramAdapt;
        this.preProc = new LatexPreProcessor(this.settings, this.executor, this.log, this.fileUtils);
        this.metaInfo = new MetaInfo(this.executor, this.log);
        this.latex2PdfCmdMagic = Optional.empty();
    }

    public LatexProcessor(Settings settings, LogWrapper log, ParameterAdapter paramAdapt) {
        this(settings, new CommandExecutor(log), log, new TexFileUtils(log), paramAdapt);
    }

    Set<Target> getTargetsForBuild(LatexMainDesc desc, Map<String, Set<Target>> docClasses2Targets, SortedSet<Target> targetSet) throws BuildFailureException {
        Optional<String> targetsMagic = desc.groupMatch(LatexMainParameterNames.targetsMagic);
        if (targetsMagic.isPresent()) {
            this.log.info("Magic comment 'targets=" + targetsMagic.get() + "' overrides settings. ");
            return Settings.getTargets(targetsMagic.get(), TargetsContext.targetsMagic);
        }
        String docClass = desc.getDocClass();
        Set<Target> possibleTargets = docClasses2Targets.get(docClass);
        if (possibleTargets == null) {
            this.log.warn("WLP09: For file '" + String.valueOf(desc.texFile) + "' targets are neither specified by magic comment nor restricted by document class '" + docClass + "'. ");
            return targetSet;
        }
        TreeSet<Target> unreachableTargets = new TreeSet<Target>(targetSet);
        unreachableTargets.removeAll(possibleTargets);
        if (!unreachableTargets.isEmpty()) {
            this.log.info("Skipping targets " + String.valueOf(unreachableTargets) + ". ");
        }
        TreeSet<Target> reachableTargets = new TreeSet<Target>(targetSet);
        reachableTargets.retainAll(possibleTargets);
        return reachableTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(SortedSet<Target> targetSet) throws BuildFailureException {
        Object object;
        this.paramAdapt.initialize();
        this.log.info("-----------create-------------");
        this.log.debug("Settings: " + this.settings.toString());
        Map<String, Set<Target>> docClasses2Targets = this.settings.getDocClassesToTargets();
        File texDir = this.settings.getTexSrcDirectoryFile();
        assert (texDir.exists() && texDir.isDirectory()) : "Expected existing tex folder " + String.valueOf(texDir);
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + String.valueOf(texDir);
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        try {
            Collection<LatexMainDesc> latexMainDescs = this.preProc.processGraphicsSelectMain(texProcDir, node, this.settings.getLatexmkUsage().preProcessInternally());
            for (LatexMainDesc desc : latexMainDescs) {
                File texFile = desc.texFile;
                this.log.info("Processing LaTeX file '" + String.valueOf(desc.texFile) + "'. ");
                File targetDir = this.fileUtils.getTargetDirectory(texFile, texDir, this.settings.getOutputDirectoryFile());
                assert (!targetDir.exists() || targetDir.isDirectory()) : "Expected target folder " + String.valueOf(targetDir) + " folder if exists. ";
                Set<Target> targetsForBuild = this.getTargetsForBuild(desc, docClasses2Targets, targetSet);
                this.latex2PdfCmdMagic = desc.groupMatch(LatexMainParameterNames.programMagic);
                if (this.latex2PdfCmdMagic.isPresent() && !this.latex2PdfCmdMagic.get().equals(this.settings.getCommand(ConverterCategory.LaTeX))) {
                    this.log.info("Magic comment 'program=" + this.latex2PdfCmdMagic.get() + "' overrides settings.");
                }
                for (Target target : targetsForBuild) {
                    boolean doTryDiff;
                    Optional<Object> pdfFileCmpOpt = Optional.empty();
                    boolean doTryVeri = target.hasVerificationTool() && this.claimsStdMetadata(desc);
                    boolean bl = doTryDiff = target.hasDiffTool() && this.isChkDiff(desc);
                    if (doTryDiff) {
                        File pdfFileCmp = TexFileUtils.getPdfFileDiff(desc.pdfFile, this.settings.getTexSrcDirectoryFile(), this.settings.getDiffDirectoryFile().getAbsoluteFile());
                        this.log.debug(String.format("cmp file %s", pdfFileCmp));
                        pdfFileCmpOpt = Optional.of(pdfFileCmp);
                        if (pdfFileCmp.exists()) {
                            long timestampSec = this.runPdfInfo(pdfFileCmp);
                            this.log.info("Process with timestamp " + String.valueOf(Instant.ofEpochSecond(timestampSec)) + " (" + timestampSec + "sec)");
                            assert (pdfFileCmpOpt.isPresent());
                            this.executor.envSetTimestampAndTZutc(timestampSec);
                        } else {
                            this.executor.envUtc();
                            this.log.info("Process with time zone UTC. ");
                        }
                    } else {
                        this.executor.envReset();
                    }
                    target.processSource(this, desc);
                    FileFilter fileFilter = TexFileUtils.getFileFilter(texFile, target.getPatternOutputFiles(this.settings), false);
                    Set<File> targetFiles = this.fileUtils.copyOutputToTargetFolder(texFile, fileFilter, targetDir);
                    if (targetFiles.size() != 1) continue;
                    File pdfFileAct = targetFiles.iterator().next();
                    this.log.debug(String.format("act file %s", pdfFileAct));
                    if (!pdfFileAct.exists()) continue;
                    Boolean coincideChecked = this.diffByNeedAndReturnEqual(doTryDiff, pdfFileAct, pdfFileCmpOpt);
                    if (!(!doTryVeri || this.settings.getVerifyByCmp() && coincideChecked != null && coincideChecked.booleanValue())) {
                        this.runValidatePdf(desc);
                    }
                    if (coincideChecked == null || coincideChecked.booleanValue()) continue;
                    throw new BuildFailureException("TLP01: Artifact '" + pdfFileAct.getName() + "' from '" + String.valueOf(texFile) + "' could not be savely reproduced. ");
                }
            }
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir, this.settings.getPrefixPytexOutFolder());
            }
            object = this.settings.isCleanUp() ? "cleanup: " + String.valueOf(texProcDir) : "No cleanup";
        }
        catch (Throwable throwable) {
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir, this.settings.getPrefixPytexOutFolder());
            }
            this.log.debug((String)(this.settings.isCleanUp() ? "cleanup: " + String.valueOf(texProcDir) : "No cleanup"));
            this.latex2PdfCmdMagic = Optional.empty();
            throw throwable;
        }
        this.log.debug((String)object);
        this.latex2PdfCmdMagic = Optional.empty();
    }

    private Boolean diffByNeedAndReturnEqual(boolean doTryDiff, File pdfFileAct, Optional<File> pdfFileCmpOpt) throws BuildFailureException {
        if (!doTryDiff) {
            this.log.debug("No artifact diff specified.");
            return null;
        }
        File pdfFileCmp = pdfFileCmpOpt.get();
        if (!pdfFileCmp.exists()) {
            this.log.warn("TLP02: Add file '" + String.valueOf(pdfFileCmp) + "' to compare with artifact '" + String.valueOf(pdfFileAct) + "'! ");
            return null;
        }
        this.log.debug("Prepare verification by diffing: ");
        boolean coincideChecked = this.runDiffPdf(pdfFileCmpOpt.get(), pdfFileAct);
        if (coincideChecked) {
            this.log.info("Checked result: coincides with expected artifact. ");
        }
        return coincideChecked;
    }

    private boolean isChkDiff(LatexMainDesc desc) {
        boolean chkDiff;
        boolean chkDiffSetting = this.settings.isChkDiff();
        if (!desc.groupMatches(LatexMainParameterNames.chkDiffMagic)) {
            return chkDiffSetting;
        }
        Optional<String> chkDiffValue = desc.groupMatch(LatexMainParameterNames.chkDiffMagicVal);
        boolean bl = chkDiff = chkDiffValue.isEmpty() ? true : Boolean.parseBoolean(chkDiffValue.get());
        if (chkDiff != chkDiffSetting) {
            this.log.info("Magic comment 'chkDiff=" + chkDiff + "' overrides setting.");
        }
        return chkDiff;
    }

    private boolean claimsStdMetadata(LatexMainDesc desc) {
        if (!desc.groupMatches(LatexMainParameterNames.docMetadata)) {
            this.log.info("No DocumenMetadata.");
            return false;
        }
        Optional<String> docMetadataValue = desc.groupMatch(LatexMainParameterNames.docMetadata);
        String docMetadataString = docMetadataValue.get();
        Pattern patStd = Pattern.compile((String)"^.*pdfstandard.*$");
        boolean claimsStd = patStd.matcher((CharSequence)docMetadataString).matches();
        if (claimsStd) {
            this.log.info("DocumenMetadata specifies standard.");
        } else {
            this.log.info("DocumenMetadata does not specify standard.");
        }
        return claimsStd;
    }

    private boolean isCompileWithLatexmk(LatexMainDesc desc) {
        boolean runLatexmk;
        boolean runLatexmkSetting = this.settings.getLatexmkUsage().runLatexmk();
        if (!desc.groupMatches(LatexMainParameterNames.latexmkMagic)) {
            return runLatexmkSetting;
        }
        Optional<String> runLatexmkValue = desc.groupMatch(LatexMainParameterNames.latexmkMagicVal);
        boolean bl = runLatexmk = runLatexmkValue.isEmpty() ? true : Boolean.parseBoolean(runLatexmkValue.get());
        if (runLatexmk != runLatexmkSetting) {
            this.log.info("Magic comment 'latexmk=" + runLatexmk + "' overrides settings. ");
        }
        return runLatexmk;
    }

    public void processGraphics() throws BuildFailureException {
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + String.valueOf(texProcDir);
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        this.preProc.processGraphicsSelectMain(texProcDir, node, true);
    }

    public void clearAll() throws BuildFailureException {
        this.paramAdapt.initialize();
        this.log.debug("Settings: " + this.settings.toString());
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + String.valueOf(texProcDir);
        this.preProc.clearCreated(texProcDir);
        this.clearInjFiles();
    }

    public String getLatex2pdfCommand() throws BuildFailureException {
        return this.latex2PdfCmdMagic.orElse(this.settings.getCommand(ConverterCategory.LaTeX));
    }

    private String getDvi2pdfCommand() throws BuildFailureException {
        return this.settings.getCommand(ConverterCategory.Dvi2Pdf);
    }

    private int preProcessLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        this.runLatex2dev(desc, dev);
        boolean posterioryEntryInToc = false;
        int minNumRunsAfter = 0;
        for (Auxiliary aux : Auxiliary.values()) {
            File auxFile = desc.withSuffix(aux.extension());
            assert (!auxFile.isDirectory());
            if (!aux.doesFitAuxiliary(auxFile)) continue;
            desc.aux2fileId.put(aux, this.getIdent(aux, auxFile));
            posterioryEntryInToc = aux.mayBeEntryInToc();
            this.log.debug("Running auxiliary " + String.valueOf((Object)aux) + ". ");
            aux.process(desc, this);
            minNumRunsAfter = Math.max(minNumRunsAfter, aux.numRunsAfter());
        }
        assert (minNumRunsAfter >= 0 && minNumRunsAfter <= 2);
        boolean hasToc = desc.withSuffix(SUFFIX_TOC).exists();
        if (hasToc && posterioryEntryInToc) {
            minNumRunsAfter = Math.max(minNumRunsAfter, 2);
        }
        if (hasToc || desc.withSuffix(SUFFIX_LOF).exists() || desc.withSuffix(SUFFIX_LOT).exists() || desc.withSuffix(SUFFIX_LOL).exists()) {
            minNumRunsAfter = Math.max(minNumRunsAfter, 1);
        }
        return minNumRunsAfter;
    }

    private FileId getIdent(Auxiliary aux, File file) {
        try {
            return aux.getIdent(file).finalizFileId();
        }
        catch (IOException ioe) {
            this.log.warn("WLP10: Degraded identifier for '" + String.valueOf(file) + "'; augmented risk not to rerun although necessary. ");
            return EMPTY_FILE_ID;
        }
    }

    private void processLatex2devCore(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        int numLatexReRuns = this.preProcessLatex2dev(desc, dev);
        String latexCmd = this.getLatex2pdfCommand();
        assert (numLatexReRuns == 0 || numLatexReRuns == 1 || numLatexReRuns == 2);
        if (numLatexReRuns > 0) {
            this.log.debug("Rerun " + latexCmd + " to update table of contents, ... bibliography, index, or that like. ");
            this.runLatex2dev(desc, dev);
            --numLatexReRuns;
        }
        assert (numLatexReRuns == 0 || numLatexReRuns == 1);
        boolean needLatexReRun = numLatexReRuns == 1 || this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        int maxNumReruns = this.settings.getMaxNumReRunsLatex();
        for (int num = 0; maxNumReruns == -1 || num < maxNumReruns; ++num) {
            for (Auxiliary aux : desc.aux2fileId.keySet()) {
                FileId fileId = this.getIdent(aux, desc.withSuffix(aux.extension()));
                if (desc.aux2fileId.get((Object)aux).equals(fileId)) continue;
                this.log.debug("Rerunning auxiliary " + String.valueOf((Object)aux) + ". ");
                desc.aux2fileId.put(aux, fileId);
                aux.process(desc, this);
                needLatexReRun = true;
            }
            if (!needLatexReRun) {
                return;
            }
            this.log.debug("Latex must be rerun. ");
            this.runLatex2dev(desc, dev);
            needLatexReRun = this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        }
        this.log.warn("WLP01: LaTeX requires rerun but maximum number " + maxNumReruns + " reached. ");
    }

    boolean needRun(boolean another, String cmdStr, File logAuxFile, String pattern) {
        FileMatch fileMatch = this.fileUtils.getMatchInFile(logAuxFile, pattern);
        if (fileMatch.isFileReadable()) {
            return fileMatch.doesExprMatch();
        }
        this.log.warn("WLP02: Cannot read " + TexFileUtils.getSuffix(logAuxFile, false) + " file '" + logAuxFile.getName() + "'; " + cmdStr + " may require " + (another ? "re" : "") + "run. ");
        return false;
    }

    private void processLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        this.processLatex2devCore(desc, dev);
        this.logWarns(desc.logFile, this.getLatex2pdfCommand());
    }

    void processLatex2dvi(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into dvi/xdv format. ");
        this.processLatex2dev(desc, LatexDev.dvips);
    }

    void processLatex2pdf(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into pdf format. ");
        if (this.isCompileWithLatexmk(desc)) {
            this.runLatexmk(desc);
            return;
        }
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2dev(desc, dev);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc);
        }
    }

    private void logErrs(File logFile, String command) {
        this.logErrs(logFile, command, this.settings.getPatternErrLatex());
    }

    private void logWarns(File logFile, String command) {
        if (!logFile.exists()) {
            return;
        }
        if (this.settings.getDebugBadBoxes() && this.hasErrsWarns(logFile, PATTERN_OUFULL_HVBOX)) {
            this.log.warn("WLP03: Running " + command + " created bad boxes logged in '" + logFile.getName() + "'. ");
        }
        if (this.settings.getDebugWarnings() && this.hasErrsWarns(logFile, this.settings.getPatternWarnLatex())) {
            this.logWarn(logFile, command);
        }
    }

    void processLatex2html(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into html format. ");
        this.preProcessLatex2dev(desc, LatexDev.devViaDvi(true));
        this.runLatex2html(desc);
    }

    void processLatex2odt(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into odt format. ");
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2odt(desc);
    }

    void processLatex2docx(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into doc(x) format. ");
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2odt(desc);
        this.runOdt2doc(desc);
    }

    void processLatex2rtf(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into rtf format. ");
        this.runLatex2rtf(desc.texFile);
    }

    void processLatex2txt(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into txt format. ");
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2devCore(desc, dev);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc);
        }
        this.runPdf2txt(desc);
    }

    public boolean printMetaInfo(boolean includeVersionInfo) throws BuildFailureException {
        SortedSet<Converter> convertersExcluded = this.settings.getConvertersExcluded();
        return this.metaInfo.printMetaInfo(includeVersionInfo, convertersExcluded);
    }

    boolean runBibtex(LatexMainDesc desc) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.BibTeX);
        this.log.debug("Running " + command + " on '" + desc.xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getBibtexOptions(), desc.xxxFile, new String[0]);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_BBL));
        File logFile = desc.withSuffix(SUFFIX_BLG);
        this.logErrs(logFile, command, this.settings.getPatternErrBibtex());
        this.logWarns(logFile, command, this.settings.getPatternWarnBibtex());
        return true;
    }

    boolean runMakeSplitIndex(LatexMainDesc desc) throws BuildFailureException {
        Set<String> explIdxIdent = this.fileUtils.collectMatchesForIdx(desc.idxFile, Pattern.compile((String)this.settings.getPatternMultiIndex()), 2);
        if (explIdxIdent == null) {
            this.log.warn("WLP04: Cannot read idx file '" + desc.idxFile.getName() + "'; skip creation of index. ");
            return false;
        }
        assert (explIdxIdent != null);
        FileFilter filter = this.fileUtils.getFileFilterReplace(desc.idxFile, "-.+");
        File[] idxFilesExtInDir = this.fileUtils.listFilesOrWarn(desc.idxFile.getParentFile(), filter);
        if (idxFilesExtInDir != null && idxFilesExtInDir.length > 0 && explIdxIdent.isEmpty()) {
            this.log.warn("WLP05: Use package 'splitidx' without option 'split' in '" + desc.texFile.getName() + "'. ");
        }
        if (explIdxIdent.isEmpty()) {
            this.runMakeIndex(desc);
        } else {
            this.runSplitIndex(desc, explIdxIdent);
        }
        return true;
    }

    private void runMakeIndex(LatexMainDesc desc) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.MakeIndex);
        File xxxFile = desc.xxxFile;
        this.log.debug("Running " + command + " on '" + xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeIndexOptions(), xxxFile, new String[0]);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.indFile);
        this.logErrs(desc.ilgFile, command, this.settings.getPatternErrMakeIndex());
        this.logWarns(desc.ilgFile, command, this.settings.getPatternWarnMakeIndex());
    }

    private File[] files(String filePrefix, Collection<String> variant, String suffix) {
        File[] res = new File[variant.size()];
        int idx = 0;
        for (String idxIdent : variant) {
            StringBuilder strb = new StringBuilder();
            strb.append(filePrefix);
            strb.append(idxIdent);
            strb.append(suffix);
            res[idx++] = new File(strb.toString());
        }
        return res;
    }

    private void runSplitIndex(LatexMainDesc desc, Collection<String> explIdxIdent) throws BuildFailureException {
        String splitInxCmd = this.settings.getCommand(ConverterCategory.SplitIndex);
        this.log.debug("Running " + splitInxCmd + " on '" + desc.xxxFile.getName() + "'. ");
        String groupIdent = "$";
        String[] argsSplitIndexDefault = new String[]{"-m " + this.settings.getCommand(ConverterCategory.MakeIndex), "-i " + this.settings.getPatternMultiIndex(), "-r " + groupIdent + "1" + groupIdent + "3", "-s -" + groupIdent + "2"};
        String argSplitindexOption = this.settings.getSplitIndexOptions();
        assert (argSplitindexOption.indexOf(32) == -1);
        String[] args = new String[argsSplitIndexDefault.length + (argSplitindexOption.isEmpty() ? 0 : 1) + 1];
        System.arraycopy(argsSplitIndexDefault, 0, args, 0, argsSplitIndexDefault.length);
        if (!argSplitindexOption.isEmpty()) {
            args[args.length - 2] = argSplitindexOption;
        }
        args[args.length - 1] = desc.xxxFile.getName();
        String optionsMakeIndex = this.settings.getMakeIndexOptions();
        if (!optionsMakeIndex.isEmpty()) {
            String[] optionsMake_IndexArr = optionsMakeIndex.split(" ");
            String[] optionsSplitIndexArr = args;
            args = new String[optionsMake_IndexArr.length + 1 + optionsSplitIndexArr.length];
            System.arraycopy(optionsSplitIndexArr, 0, args, 0, optionsSplitIndexArr.length);
            args[optionsSplitIndexArr.length] = "--";
            System.arraycopy(optionsMake_IndexArr, 0, args, optionsSplitIndexArr.length + 1, optionsMake_IndexArr.length);
        }
        String filePrefix = desc.xxxFile.toString() + SEP_IDENT_IDX;
        File[] indFiles = this.files(filePrefix, explIdxIdent, SUFFIX_IND);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), splitInxCmd, args, indFiles);
        File[] ilgFiles = this.files(filePrefix, explIdxIdent, SUFFIX_ILG);
        splitInxCmd = this.settings.getCommand(ConverterCategory.MakeIndex);
        for (int idx = 0; idx < explIdxIdent.size(); ++idx) {
            this.logErrs(ilgFiles[idx], splitInxCmd, this.settings.getPatternErrMakeIndex());
            this.logWarns(ilgFiles[idx], splitInxCmd, this.settings.getPatternWarnMakeIndex());
        }
    }

    boolean runMakeGlossary(LatexMainDesc desc) throws BuildFailureException {
        String patternWarn;
        String patternErr;
        File xxxFile = desc.xxxFile;
        String command = this.settings.getCommand(ConverterCategory.MakeGlossaries);
        this.log.debug("Running " + command + " on '" + xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeGlossariesOptions(), xxxFile, new String[0]);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.glsFile);
        Boolean isMakeIndexOrLike = this.fileUtils.withMakindexLike(desc.auxFile);
        if (isMakeIndexOrLike != null && isMakeIndexOrLike.booleanValue()) {
            patternErr = this.settings.getPatternErrMakeIndex();
            patternWarn = this.settings.getPatternWarnMakeIndex();
        } else {
            patternErr = this.settings.getPatternErrXindy();
            patternWarn = this.settings.getPatternWarnXindy();
        }
        Set<String> extLogFiles = this.fileUtils.collectLogsForGloss(desc.auxFile);
        if (isMakeIndexOrLike == null || extLogFiles == null) {
            this.log.warn("WLPXX: Cannot read AUX file; skipping evaluating log files for glossaries. ");
            return true;
        }
        for (String ext : extLogFiles) {
            File logFile = desc.withSuffix("." + ext);
            this.logErrs(logFile, command, patternErr);
            this.logWarns(logFile, command, patternWarn);
        }
        return true;
    }

    boolean runPythontex(LatexMainDesc desc) throws BuildFailureException {
        boolean isDel;
        File xxxFile = desc.xxxFile;
        String command = this.settings.getCommand(ConverterCategory.Pythontex);
        this.log.debug("Running " + command + " on '" + xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPythontexOptions(), desc.xxxFile, new String[0]);
        File outFolder = TexFileUtils.replacePrefix(this.settings.getPrefixPytexOutFolder(), desc.xxxFile);
        String repOutFileName = desc.xxxFile.getName() + SUFFIX_PYTXMCR;
        File repOutFile = new File(outFolder, repOutFileName);
        if (repOutFile.exists() && !(isDel = repOutFile.delete())) {
            this.log.warn("Preliminary warning: Could not delete '" + String.valueOf(repOutFile) + "'; this may cause further warnings/errors. ");
        }
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, repOutFile);
        File logFile = desc.withSuffix(SUFFIX_PLG);
        this.logErrs(logFile, command, this.settings.getPatternErrPyTex());
        this.logWarns(logFile, command, this.settings.getPatternWarnPyTex());
        return true;
    }

    private void runLatexmk(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getLatexmkCommand();
        String[] args = LatexProcessor.buildLatexmkArguments(this.settings, desc);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        this.executor.executeBuild(desc.parentDir, this.settings.getTexPath(), command, args, desc.pdfFile);
    }

    protected static String[] buildLatexmkArguments(Settings settings, LatexMainDesc desc) throws BuildFailureException {
        ArrayList addArgs = new ArrayList();
        return LatexProcessor.buildArguments(settings.getLatexmkOptions(), desc.texFile, addArgs.toArray(new String[addArgs.size()]));
    }

    private void runLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.getLatex2pdfCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        boolean isTypeXelatex = Converter.XeLatex.getCommand().equals(command);
        String[] args = LatexProcessor.buildLatexArguments(this.settings, dev, texFile, isTypeXelatex);
        File latexTargetFile = dev.latexTargetFile(desc, isTypeXelatex);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, latexTargetFile);
        this.logErrs(desc.logFile, command);
    }

    protected static String[] buildLatexArguments(Settings settings, LatexDev dev, File texFile, boolean isTypeXelatex) throws BuildFailureException {
        String options = settings.getLatex2pdfOptions();
        if (dev.isDefault()) {
            return LatexProcessor.buildArguments(options, texFile, new String[0]);
        }
        return LatexProcessor.buildArguments(options, texFile, new String[]{isTypeXelatex ? "-no-pdf" : "-output-format=" + dev.getLatexOutputFormat()});
    }

    private void runDvi2pdf(LatexMainDesc desc) throws BuildFailureException {
        assert (this.settings.getPdfViaDvi().isViaDvi());
        String command = this.getDvi2pdfCommand();
        if (desc.dviFile.exists() && desc.xdvFile.exists()) {
            this.log.warn("WLP07: Found both '" + String.valueOf(desc.dviFile) + "' and '" + String.valueOf(desc.xdvFile) + "'; convert the latter. ");
        }
        this.log.debug("Running " + command + " on '" + desc.xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getDvi2pdfOptions(), desc.xxxFile, new String[0]);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.pdfFile);
    }

    private void runLatex2html(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildHtlatexArguments(this.settings, texFile);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_HTML));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    protected static String[] buildHtlatexArguments(Settings settings, File texFile) {
        return new String[]{texFile.getName(), settings.getTex4htStyOptions(), settings.getTex4htOptions(), settings.getT4htOptions(), settings.getLatex2pdfOptions()};
    }

    private void runLatex2rtf(File texFile) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.LaTeX2Rtf);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getLatex2rtfOptions(), texFile, new String[0]);
        this.executor.executeEnvR0(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_RTF));
    }

    private void runLatex2odt(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = new String[]{texFile.getName(), "xhtml,ooffice", "ooffice/! -cmozhtf", "-coo -cvalidate"};
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_ODT));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    private void runOdt2doc(LatexMainDesc desc) throws BuildFailureException {
        File odtFile = desc.withSuffix(SUFFIX_ODT);
        String command = this.settings.getCommand(ConverterCategory.Odt2Doc);
        this.log.debug("Running " + command + " on '" + odtFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getOdt2docOptions(), odtFile, new String[0]);
        String suffix = null;
        for (int idx = 0; idx < args.length - 1; ++idx) {
            if (!args[idx].startsWith("-f")) continue;
            assert (suffix == null);
            suffix = args[idx].substring(2, args[idx].length());
        }
        assert (suffix != null);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(suffix));
    }

    private void runPdf2txt(LatexMainDesc desc) throws BuildFailureException {
        File pdfFile = desc.withSuffix(".pdf");
        String command = this.settings.getCommand(ConverterCategory.Pdf2Txt);
        this.log.debug("Running " + command + " on '" + pdfFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPdf2txtOptions(), pdfFile, new String[0]);
        this.executor.executeEnvR0(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_TXT));
    }

    void processCheck(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Checking source. ");
        this.runChktex(desc);
    }

    private void runChktex(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        File clgFile = desc.withSuffix(SUFFIX_CLG);
        String command = this.settings.getCommand(ConverterCategory.LatexChk);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildChkTexArguments(this.settings.getChkTexOptions(), texFile, clgFile);
        CommandExecutor.CmdResult res = this.executor.executeEmptyEnv(texFile.getParentFile(), this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsOne, args, clgFile);
        switch (res.returnCode) {
            case 0: {
                if (!clgFile.exists() || clgFile.length() == 0L) break;
                this.log.info("Checker '" + command + "' logged a message in '" + clgFile.getName() + "'. ");
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.log.error("ELP02: Checker '" + command + "' logged an error in '" + clgFile.getName() + "'. ");
                break;
            }
            case 2: {
                this.log.warn("WLP08: Checker '" + command + "' logged a warning in '" + clgFile.getName() + "'. ");
                break;
            }
            default: {
                this.logErrUnexpectedReturnCode(command, res);
            }
        }
    }

    private void logErrUnexpectedReturnCode(String command, CommandExecutor.CmdResult res) {
        this.log.error("ELP01: For command '" + command + "' found unexpected return code " + res.returnCode + ". ");
    }

    private void runValidatePdf(LatexMainDesc desc) throws BuildFailureException {
        File pdfFile = desc.pdfFile;
        String command = this.settings.getCommand(ConverterCategory.StandardValidator);
        this.log.debug("Running " + command + " on '" + pdfFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getChkTexOptions(), pdfFile, new String[0]);
        CommandExecutor.CmdResult res = this.executor.executeEmptyEnv(pdfFile.getParentFile(), this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsNotZeroOrOne, args, new File[0]);
        switch (res.returnCode) {
            case 0: {
                this.log.info("Validation of '" + pdfFile.getName() + "' passed. ");
                break;
            }
            case 1: {
                this.log.warn("XXX: Validation of '" + pdfFile.getName() + "' failed. ");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                this.logErrUnexpectedReturnCode(command, res);
            }
        }
    }

    protected static String[] buildChkTexArguments(String options, File texFile, File clgFile) {
        return LatexProcessor.buildArguments(options, texFile, "-o", clgFile.getName());
    }

    private boolean runDiffPdf(File pdfFileCmp, File pdfFileAct) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.DiffPdf);
        this.log.debug("Running " + command + " diffing '" + pdfFileCmp.getName() + "' and '" + pdfFileAct.getName() + "'. ");
        String[] args = new String[]{pdfFileCmp.toString(), pdfFileAct.toString()};
        CommandExecutor.CmdResult res = this.executor.executeEmptyEnv(null, this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsNotZeroOrOne, args, new File[0]);
        int returnCode = res.returnCode;
        switch (returnCode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.logErrUnexpectedReturnCode(command, res);
            }
        }
        return returnCode == 0;
    }

    long runPdfInfo(File pdfFile) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.MetaInfoPdf);
        this.log.debug("Running " + command + " extracting metainformation from '" + pdfFile.getName() + "''. ");
        String[] args = new String[]{this.settings.getPdfMetainfoOptions(), pdfFile.toString()};
        CommandExecutor.CmdResult res = this.executor.executeEmptyEnv(null, this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsNonZero, args, new File[0]);
        Pattern pattern = Pattern.compile((String)"CreationDate:\\s*(?<creationDate>.*)\\R");
        Matcher matcher = pattern.matcher((CharSequence)res.output);
        if (!matcher.find()) {
            throw new RuntimeException("Found no creation date");
        }
        String creationDateIso8601 = matcher.group("creationDate");
        long epochTimeSec = ZonedDateTime.parse(creationDateIso8601).toEpochSecond();
        return epochTimeSec;
    }

    public void processFileInjections(Set<Injection> injections) throws BuildFailureException {
        for (Injection inj : injections) {
            String fileName = inj.getFileName();
            InputStream inStream = MetaInfo.getStream(FOLDER_INJ + fileName);
            File outFile = this.settings.rcResourceToFile(fileName);
            try {
                if (!outFile.exists() || this.fileUtils.isCreatedByMyself(outFile, inj)) {
                    PrintStream writer = new PrintStream(outFile);
                    String version = this.metaInfo.getCoordinates().version;
                    this.settings.filterInjection(inStream, writer, version, inj);
                }
                inStream.close();
            }
            catch (IOException ioe) {
                throw new BuildFailureException("TLP03 Failure while writing file '" + fileName + "' or closing in-stream. ", ioe);
            }
            boolean success = outFile.setExecutable(inj.setExecutable(), false);
            assert (success || !inj.setExecutable());
        }
    }

    private void clearInjFiles() {
        for (Injection inj : Injection.values()) {
            File outFile = this.settings.rcResourceToFile(inj.getFileName());
            if (!outFile.exists() || !this.fileUtils.isCreatedByMyself(outFile, inj)) continue;
            this.fileUtils.deleteOrError(outFile, false);
        }
    }
}

