/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaInfo {
    private static final String META_FOLDER = "META-INF/";
    private static final String VERSION_PROPS_FILE = "version.properties";
    private static final String TOOL_VERSION_FORMAT = "%s%-18s %s '%s'%s%s";
    private static final String CMD_WHICH = "which";
    private static final String COORDINATE_PROPERTY_FILE_NAME = "META-INF/maven/eu.simuline.m2latex/latex-maven-plugin/pom.properties";
    private final CommandExecutor executor;
    private final LogWrapper log;
    private static final String VERSION_QUOTE = "version ";

    static InputStream getStream(String fileName) throws BuildFailureException {
        InputStream res = MetaInfo.class.getClassLoader().getResourceAsStream(fileName);
        if (res == null) {
            throw new BuildFailureException("TMI01: Cannot get stream to file '" + fileName + "'. ");
        }
        return res;
    }

    static Properties getProperties(String fileName) throws BuildFailureException {
        try {
            Properties properties = new Properties();
            properties.load(MetaInfo.getStream(fileName));
            return properties;
        }
        catch (IOException e) {
            throw new BuildFailureException("TMI02: Cannot load properties from file '" + fileName + "'. ");
        }
    }

    MetaInfo(CommandExecutor executor, LogWrapper log) {
        this.executor = executor;
        this.log = log;
    }

    Coordinates getCoordinates() throws BuildFailureException {
        Properties properties = MetaInfo.getProperties(COORDINATE_PROPERTY_FILE_NAME);
        assert ("[groupId, artifactId, version]".equals(properties.stringPropertyNames().toString())) : "Found unexpected properties ";
        return new Coordinates(properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"));
    }

    public boolean printMetaInfo(boolean includeVersionInfo, SortedSet<Converter> convertersExcluded) throws BuildFailureException {
        Properties versionProperties;
        if (includeVersionInfo) {
            ManifestInfo manifestInfo = new ManifestInfo();
            this.log.info("Manifest properties: ");
            String[] stringArray = manifestInfo.toStringArr();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.log.info(line);
                ++n2;
            }
            this.log.info("pom properties: coordinates");
            Coordinates coords = this.getCoordinates();
            this.log.info("groupId:    '" + coords.groupId + "'");
            this.log.info("artifactId: '" + coords.artifactId + "'");
            this.log.info("version:    '" + coords.version + "'");
            GitProperties gitProperties = new GitProperties();
            this.log.info("git properties: ");
            gitProperties.log();
            String gitBuildVersion = gitProperties.getBuildVersion();
            assert (gitBuildVersion.equals(manifestInfo.getImplVersion()));
            this.log.info("tool versions: ");
            this.log.info(MetaInfo.versionLine("?warning? ", "command", includeVersionInfo, "actual version", "(not)in", "[expected version interval]"));
        }
        if ((versionProperties = MetaInfo.getProperties(VERSION_PROPS_FILE)).size() > Converter.values().length) {
            throw new IllegalStateException("Number of version properties " + versionProperties.size() + " does not fit number of converters " + Converter.values().length + ". ");
        }
        boolean doWarnAny = false;
        TreeSet<Converter> convertersNotFound = new TreeSet<Converter>();
        Converter[] converterArray = Converter.values();
        int n = converterArray.length;
        int n3 = 0;
        while (n3 < n) {
            Converter conv = converterArray[n3];
            doWarnAny |= this.logConverterInfo(conv, includeVersionInfo, convertersExcluded, convertersNotFound, versionProperties);
            ++n3;
        }
        if (includeVersionInfo) {
            if (!convertersExcluded.isEmpty()) {
                this.log.info("tools excluded: ");
                this.log.info(Converter.toCommandsString(convertersExcluded));
            }
            if (!convertersNotFound.isEmpty()) {
                this.log.info("tools not found: ");
                this.log.info(Converter.toCommandsString(convertersNotFound));
            }
        }
        return doWarnAny;
    }

    private static String versionLine(String warnStr, String cmdStr, boolean includeVersionInfo, String versionStr, String inclStr, String expVersionInterval) {
        return String.format(TOOL_VERSION_FORMAT, warnStr, cmdStr + ":", includeVersionInfo ? "" : VERSION_QUOTE, versionStr, inclStr, expVersionInterval);
    }

    private boolean logConverterInfo(Converter conv, boolean includeVersionInfo, SortedSet<Converter> convertersExcluded, SortedSet<Converter> convertersNotFound, Properties versionProperties) throws BuildFailureException {
        String warnStr;
        String inclStr;
        assert (convertersNotFound.isEmpty());
        if (convertersExcluded.contains((Object)conv)) {
            return false;
        }
        String cmdStr = conv.getCommand();
        CommandExecutor.CmdResult resultWhich = this.executor.executeEmptyEnv(TexFileUtils.getEmptyIdx().getParentFile(), null, CMD_WHICH, CommandExecutor.ReturnCodeChecker.Never, new String[]{cmdStr}, new File[0]);
        if (resultWhich.returnCode == 1) {
            convertersNotFound.add(conv);
            return false;
        }
        Version actVersionObj = new Version(conv, this.executor);
        String expVersionStr = versionProperties.getProperty(cmdStr);
        VersionInterval expVersionInterval = new VersionInterval(conv, expVersionStr);
        boolean doWarn = false;
        if (actVersionObj.isMatching()) {
            boolean bl = doWarn = !expVersionInterval.contains(actVersionObj);
            if (doWarn) {
                inclStr = "not in";
                warnStr = "WMI02: ";
            } else {
                if (!includeVersionInfo) {
                    return false;
                }
                warnStr = "          ";
                inclStr = "in";
            }
        } else {
            doWarn = true;
            this.log.warn("WMI01: Version string from converter " + String.valueOf((Object)conv) + " did not match expected form: \n" + actVersionObj.getText());
            inclStr = "not?in";
            warnStr = "       ";
        }
        String logMsg = MetaInfo.versionLine(warnStr, cmdStr, includeVersionInfo, actVersionObj.getString(), inclStr, expVersionStr);
        if (doWarn) {
            this.log.warn(logMsg);
        } else {
            this.log.info(logMsg);
        }
        return doWarn;
    }

    static class Coordinates {
        final String groupId;
        final String artifactId;
        final String version;

        Coordinates(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }

    class GitProperties {
        private static final String GIT_PROPS_FILE = "git.properties";
        private static final String GIT_BUILD_VERSION = "git.build.version";
        private static final String GIT_COMMIT_ID_DESCRIBE = "git.commit.id.describe";
        private static final String GIT_CLOSEST_TAG_NAME = "git.closest.tag.name";
        private static final String GIT_CLOSEST_TAG_COMMIT_COUNT = "git.closest.tag.commit.count";
        private static final String GIT_COMMIT_ID_ABBREV = "git.commit.id.abbrev";
        private static final String GIT_DIRTY = "git.dirty";
        private static final String GIT_BUILD_TIME = "git.build.time";
        private final Properties properties = MetaInfo.getProperties("git.properties");

        GitProperties() throws BuildFailureException {
        }

        private String getAttrValue(String key) {
            return this.properties.get(key).toString();
        }

        String getBuildVersion() {
            return this.getAttrValue(GIT_BUILD_VERSION);
        }

        String getCommitIdDescribe() {
            return this.getAttrValue(GIT_COMMIT_ID_DESCRIBE);
        }

        String getClosestTagName() {
            return this.getAttrValue(GIT_CLOSEST_TAG_NAME);
        }

        String getClosestTagCommitCount() {
            return this.getAttrValue(GIT_CLOSEST_TAG_COMMIT_COUNT);
        }

        String getCommitIdAbbrev() {
            return this.getAttrValue(GIT_COMMIT_ID_ABBREV);
        }

        String getDirty() {
            return this.getAttrValue(GIT_DIRTY);
        }

        String getBuildTime() {
            return this.getAttrValue(GIT_BUILD_TIME);
        }

        public String toString() {
            StringBuilder stb = new StringBuilder();
            stb.append("build version:  '" + this.getBuildVersion() + "'\n");
            stb.append("commit id desc: '" + this.getCommitIdDescribe() + "'\n");
            stb.append("buildTime:      '" + this.getBuildTime() + "'\n");
            return stb.toString();
        }

        void log() {
            MetaInfo.this.log.info("build version:  '" + this.getBuildVersion() + "'");
            MetaInfo.this.log.info("commit id desc: '" + this.getCommitIdDescribe() + "'");
            MetaInfo.this.log.info("buildTime:      '" + this.getBuildTime() + "'");
        }
    }

    static class ManifestInfo {
        private static final String MANIFEST_VERSION = "1.0";
        private static final String MVN_JAR_PLUGIN = "Maven JAR Plugin 3.4.2";
        private static final String MANIFEST_FILE = "MANIFEST.MF";
        private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
        private static final Attributes.Name BUILD_JDK_SPEC = new Attributes.Name("Build-Jdk-Spec");
        private final Manifest manifest;
        private final Attributes mAtts;

        ManifestInfo() throws BuildFailureException {
            try {
                this.manifest = new Manifest(MetaInfo.getStream("META-INF/MANIFEST.MF"));
            }
            catch (IOException e) {
                throw new BuildFailureException("TMI03: IOException reading manifest. ");
            }
            this.mAtts = this.manifest.getMainAttributes();
            if (!MANIFEST_VERSION.equals(this.getManifestVersion())) {
                throw new IllegalStateException("Found manifest with version '" + this.getManifestVersion() + " where expected version 1.0. ");
            }
            if (!MVN_JAR_PLUGIN.equals(this.mAtts.get(CREATED_BY))) {
                throw new IllegalStateException("Found manifest not created by 'Maven JAR Plugin 3.4.2' message was '" + String.valueOf(this.mAtts.get(CREATED_BY)) + "'. ");
            }
        }

        private String getAttrValue(Object name) {
            return this.mAtts.get(name).toString();
        }

        protected String getImplVersion() {
            return this.getAttrValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }

        protected String getImplVendor() {
            return this.getAttrValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }

        protected String getManifestVersion() {
            return this.getAttrValue(Attributes.Name.MANIFEST_VERSION);
        }

        protected String getSpecVersion() {
            return this.getAttrValue(Attributes.Name.SPECIFICATION_VERSION);
        }

        protected String getCreatedBy() {
            return this.getAttrValue(CREATED_BY);
        }

        protected String getBuildJdkSpec() {
            return this.getAttrValue(BUILD_JDK_SPEC);
        }

        protected String getPackageImplVersion() {
            return this.getClass().getPackage().getImplementationVersion();
        }

        public String toString() {
            StringBuilder stb = new StringBuilder();
            String[] stringArray = this.toStringArr();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                stb.append(line);
                stb.append('\n');
                ++n2;
            }
            return stb.toString();
        }

        public String[] toStringArr() {
            return new String[]{"MANIFEST: (" + this.getManifestVersion() + ")", "       Implementation-Version: '" + this.getImplVersion() + "'", "PackageImplementation-Version: '" + this.getPackageImplVersion() + "'"};
        }
    }

    static class Version
    implements Comparable<Version> {
        private static final String VERSION_UNKNOWN = "<unknown>";
        private final String text;
        private final Matcher matcher;
        private final String versionStr;
        private final List<Number> segments;

        Version(Converter conv, CommandExecutor executor) throws BuildFailureException {
            this(conv.getVersionEnvironment(), conv.getVersionPattern(), conv.getVersionInfo(executor));
        }

        Version(String patternEnv, String patternVrs, String text) {
            this.text = text;
            this.matcher = Pattern.compile(String.format(patternEnv, patternVrs)).matcher(text);
            if (!this.matcher.find()) {
                this.versionStr = VERSION_UNKNOWN;
                this.segments = null;
                return;
            }
            this.versionStr = this.matcher.group(1);
            this.segments = new ArrayList<Number>(this.matcher.groupCount() - 1);
            int idx = 2;
            while (idx <= this.matcher.groupCount()) {
                String segment = this.matcher.group(idx);
                if (segment == null) break;
                Number num = Version.segStr2Num(segment);
                this.segments.add(num);
                ++idx;
            }
        }

        private static Number segStr2Num(String segment) {
            if (segment.isEmpty()) {
                return (byte)127;
            }
            if (Pattern.matches("[a-z]", segment)) {
                return (byte)segment.codePointAt(0);
            }
            if (segment.indexOf(46) == -1) {
                return Integer.valueOf(segment);
            }
            return Double.valueOf(segment);
        }

        boolean isMatching() {
            return this.segments != null;
        }

        String getText() {
            return this.text;
        }

        String getString() {
            return this.versionStr;
        }

        private List<Number> getSegments() {
            return this.segments;
        }

        @Override
        public int compareTo(Version other) {
            int idxMin = Math.min(this.getSegments().size(), other.getSegments().size());
            int idx = 0;
            while (idx < idxMin) {
                int sign = (int)Math.signum(this.getSegments().get(idx).doubleValue() - other.getSegments().get(idx).doubleValue());
                switch (sign) {
                    case 0: {
                        break;
                    }
                    case -1: 
                    case 1: {
                        return sign;
                    }
                    default: {
                        throw new IllegalStateException("Found unexpected signum. ");
                    }
                }
                ++idx;
            }
            return this.getSegments().size() - other.getSegments().size();
        }
    }

    static class VersionInterval {
        private static final char SEP = ';';
        private static final String ENV_PATTERN1 = "^\\[%s\\]$";
        private static final String ENV_PATTERN2LOW = "^\\[%s;.*\\]$";
        private static final String ENV_PATTERN2HIG = "^\\[.*;%s\\]$";
        private final Version min;
        private final Version max;

        VersionInterval(Converter conv, String text) {
            String expVersionItvStr;
            String patternVrs = conv.getVersionPattern();
            if (text == null) {
                throw new IllegalStateException("Found no expected version for converter " + String.valueOf((Object)conv) + ". ");
            }
            if (text.indexOf(59) == -1) {
                this.max = this.min = new Version(ENV_PATTERN1, patternVrs, text);
                if (!this.min.isMatching()) {
                    throw new IllegalStateException(String.format("Expected version interval '%s' does not match expression '^\\[%s\\]$'. ", text, patternVrs));
                }
            } else {
                this.min = new Version(ENV_PATTERN2LOW, patternVrs, text);
                this.max = new Version(ENV_PATTERN2HIG, patternVrs, text);
                if (!this.min.isMatching() || !this.max.isMatching()) {
                    throw new IllegalStateException(String.format("Expected version interval '%s' does not match expression '^\\[%s%c%s\\]$'. ", text, patternVrs, Character.valueOf(';'), patternVrs));
                }
            }
            if (!text.equals(expVersionItvStr = this.toString())) {
                throw new IllegalStateException(String.format("Expected version '%s' reconstructed as '%s'. ", text, expVersionItvStr));
            }
        }

        boolean contains(Version version) {
            return this.min.compareTo(version) <= 0 && this.max.compareTo(version) >= 0;
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            res.append('[');
            res.append(this.min.getString());
            if (this.min != this.max) {
                res.append(';');
                res.append(this.max.getString());
            }
            res.append(']');
            return res.toString();
        }
    }
}

